// quickSort3.java
// Program demonstruje dziaanie algorytmu quicksort; 
// niewielkie grupy danych sortowane s metod sortowania przez wstawianie
// Aby uruchomi ten program: C>java QuickSort3App
////////////////////////////////////////////////////////////////
class ArrayIns
   {
   private long[] theArray;          // odwoanie do tablicy theArray
   private int nElems;               // ilo elementw
//--------------------------------------------------------------
   public ArrayIns(int max)          // konstruktor
      {
      theArray = new long[max];      // tworzymy tablic
      nElems = 0;                    // pocztkowo pust
      }
//--------------------------------------------------------------
   public void insert(long value)    // dodanie elementu do tablicy
      {
      theArray[nElems] = value;      // wstawiamy element
      nElems++;                      // inkrementujemy wielko tablicy
      }
//--------------------------------------------------------------
   public void display()             // wywietlenie zawartoci tablicy
      {
      System.out.print("A=");
      for(int j=0; j<nElems; j++)    // dla kadego elementu
         System.out.print(theArray[j] + " ");  // wywietlamy go
      System.out.println("");
      }
//--------------------------------------------------------------
   public void quickSort()
      {
      recQuickSort(0, nElems-1);
      // insertionSort(0, nElems-1);  // kolejna opcja 
      }
//--------------------------------------------------------------
   public void recQuickSort(int left, int right)
      {
      int size = right-left+1;
      if(size < 10)                   // niewielkie grupy danych sortumemy
         insertionSort(left, right);  // metod sortowania przes wstawianie
      else                            // wiksze grupy sortujemy metod quicksort
         {                            
         long median = medianOf3(left, right);
         int partition = partitionIt(left, right, median);
         recQuickSort(left, partition-1);
         recQuickSort(partition+1, right);
         }
      }  // koniec metody recQuickSort()
//--------------------------------------------------------------
   public long medianOf3(int left, int right)
      {
      int center = (left+right)/2;
                                         // kolejno elem.: lewego i rodkowego
      if( theArray[left] > theArray[center] )
         swap(left, center);
                                         // kolejno elem.: lewego i prawego
      if( theArray[left] > theArray[right] )
         swap(left, right);
                                         // kolejno elem.: rodkowego i prawego
      if( theArray[center] > theArray[right] )
         swap(center, right);

      swap(center, right-1);             // umieszczamy o podziau z prawej strony
      return theArray[right-1];          // zwracamy warto mediany
      }  // koniec metody medianOf3()
//--------------------------------------------------------------
   public void swap(int dex1, int dex2)  // zamiana pooenia dwch elementw
      {
      long temp = theArray[dex1];        // zapisujemy A w temp
      theArray[dex1] = theArray[dex2];   // zapisujemy B w A
      theArray[dex2] = temp;             // zapisujemy temp w B
      }  // koniec metody swap(
//--------------------------------------------------------------
    public int partitionIt(int left, int right, long pivot)
       {
       int leftPtr = left;             // na prawo od pierwszego elementu
       int rightPtr = right - 1;       // na lewo od osi podziau

       while(true)
          {
          while( theArray[++leftPtr] < pivot )  // znajdujemy wikszy
             ;                                  //    (nic nie robimy)
          while( theArray[--rightPtr] > pivot ) // znajdujemy mniejszy
             ;                                  //    (nic nie robimy)
          if(leftPtr >= rightPtr)      // jeli kolejno wskanikw si zmieni,
             break;                    //    dzielimy dane
          else                         // kolejo nie ulega zmianie, a zatem
             swap(leftPtr, rightPtr);  // zamieniamy elementy
          }  // koniec ptli while(true)
       swap(leftPtr, right-1);         // przenosimy element stanowicy o podziau
       return leftPtr;                 // zwracamy indeks tego elementu
       }  // end partitionIt()
//--------------------------------------------------------------
                                       // sortowanie przez wstawianie
   public void insertionSort(int left, int right)
      {
      int in, out;
                                       //  posortowane na lewo od indeksu out
      for(out=left+1; out<=right; out++)
         {
         long temp = theArray[out];    // usuwamy zanczony element
         in = out;                     // zaczynamy przesuwa od komrki o indeksie out
                                       // a do chwili gdy znajdziemy mniejsz warto,
         while(in>left && theArray[in-1] >= temp)
            {
            theArray[in] = theArray[in-1]; // przesuwamy element w prawo
            --in;                      // przechodzimy o jedn pozycj w lewo
            }
         theArray[in] = temp;          // wstawiamy zanaczony element
         }  // koniec ptli for
      }  // koniec metody insertionSort()
//--------------------------------------------------------------
   }  // koniec klasy ArrayIns
////////////////////////////////////////////////////////////////
class QuickSort3App
   {
   public static void main(String[] args)
      {
      int maxSize = 16;             // wielko tablicy
      ArrayIns arr;                 // odwoanie do tablicy
      arr = new ArrayIns(maxSize);  // tworzymy tablic

      for(int j=0; j<maxSize; j++)  // zapisujemy w tablicy 
         {                          // wartoci losowe
         long n = (int)(java.lang.Math.random()*99);
         arr.insert(n);
         }
      arr.display();                // wywietlamy tablic
      arr.quickSort();              // sortujemy je metod quicksort
      arr.display();                // ponownie wywietlamy tablic
      }  // koniec metody main()
   }  // koniec klasy QuickSort3App
////////////////////////////////////////////////////////////////
